set more off
set matsize 11000
cd "C:\Users\Thomas.Pellet\OneDrive - Peterson Institute for International Economics\2017-11\JEP OB paper natural rate\Figure 7"
use infl_urate_a_us.dta, clear 

********************************************************************************

tsset year
sort year

scalar window=15

gen rollingcoefinfl=.
gen rollingcoefu=.

gen rollingcoefinfl_se=.
gen rollingcoefu_se=.


forval x = 1948/2002 { //endyear= 2017 - window
capture noisily reg infl L.infl urate if year>=`x' & year<=window-1+`x' //n-year rolling sample
replace rollingcoefinfl = _b[L.infl] if year==window-1+`x'
replace rollingcoefinfl_se = _se[L.infl] if year==window-1+`x'
replace rollingcoefu= _b[urate] if year==window-1+`x'
replace rollingcoefu_se = _se[urate] if year==window-1+`x'

}

gen rollingcoefinflu = rollingcoefinfl + 1*rollingcoefinfl_se
gen rollingcoefinfll = rollingcoefinfl - 1*rollingcoefinfl_se
gen rollingcoefuu = rollingcoefu + 1*rollingcoefu_se
gen rollingcoeful = rollingcoefu - 1*rollingcoefu_se

save infl_urate_a_us_results.dta, replace

twoway (line rollingcoefinfl year) if year >=1960
twoway (line rollingcoefinfl year) (line rollingcoefinflu year) (line rollingcoefinfll year) if year >=1960

line rollingcoefu rollingcoefuu rollingcoeful year  if year >=1960, lp(solid dash dash)
line rollingcoefinfl rollingcoefinflu rollingcoefinfll year  if year >=1960, lp(solid dash dash)
